#pragma once

#include <memory>

#include "../uiwindow.h"
#include "../menuselectoption.h"

#include "../../skiplist.h"

class SkipList;
class Ui;
class FocusableArea;
class MenuSelectAdjustableLine;
class MenuSelectOptionTextField;
class MenuSelectOptionTextArrow;
class MenuSelectOptionElement;

class SkipListScreen : public UIWindow {
public:
  SkipListScreen(Ui *);
  ~SkipListScreen();
  void initialize(unsigned int row, unsigned int col, SkipList * skiplist);
  void redraw() override;
  bool keyPressed(unsigned int) override;
  std::string getLegendText() const override;
  std::string getInfoLabel() const override;
private:
  void initialize();
  void saveToTempSkipList();
  void addPatternLine(int y, bool regex, std::string pattern, bool file, bool dir,
                      int scope, SkipListAction action,
                      std::shared_ptr<MenuSelectAdjustableLine> before = nullptr);
  bool keyUp() override;
  bool keyDown() override;
  int getCurrentScope() const;
  void recreateTable();
  bool onDeactivated(const std::shared_ptr<MenuSelectOptionElement>& msoe) override;
  SkipList * skiplist;
  MenuSelectOption base;
  MenuSelectOption table;
  FocusableArea * focusedarea;
  FocusableArea * defocusedarea;
  SkipList testskiplist;
  std::shared_ptr<MenuSelectOptionTextField> testpattern;
  std::shared_ptr<MenuSelectOptionTextArrow> testtype;
  std::shared_ptr<MenuSelectOptionCheckBox> testinspreadjob;
  unsigned int currentviewspan;
  bool globalskip;
  bool temphighlightline;
};
